/* eslint-disable */
var STJSBridge;
(function (STJSBridge) {
    var __host__defined__ = "pandora://game";
    /**
     * 消息模型
     */
    var STMessage = /** @class */ (function () {
        function STMessage(data) {
            /**
             * 消息发送 ID
             *
             * @type {number}
             */
            this.requestId = 0;
            if (data) {
                this.responseId = data['responseId'];
                this.name = data['name'];
                this.content = data['content'];
                this.requestId = data['requestId'];
                this.error = data['error'];
            }
        }
        /**
         * 返回序列化的数据
         *
         * @return {object}
         */
        STMessage.prototype.json = function () {
            var dic = {};
            dic['requestId'] = this.requestId;
            if (this.responseId) {
                dic['responseId'] = this.responseId;
            }
            if (this.name) {
                dic['name'] = this.name;
            }
            if (this.content) {
                dic['content'] = this.content;
            }
            if (this.error) {
                dic['error'] = this.error;
            }
            return dic;
        };
        return STMessage;
    }());
    /**
     * 对消息处理
     *
     */
    var STMessageManager = /** @class */ (function () {
        function STMessageManager() {
            this.eventMap = {};
            this.noneNameEventHandler = function () { };
            this.callBackList = {};
            this.requestId = 0;
        }
        STMessageManager.prototype.formWebToClient = function (name, content, complete) {
            var message = new STMessage();
            message.requestId = ++this.requestId;
            message.name = name;
            message.content = content;
            if (complete) {
                this.callBackList[message.requestId] = complete;
            }
            this.sendMessage(message);
        };
        STMessageManager.prototype.formClientToWeb = function (data) {
            var _this = this;
            var message = new STMessage(data);
            var name = message.name;
            if (message.responseId) {
                if (message.responseId in this.callBackList) {
                    var callback = this.callBackList[message.responseId];
                    callback(message.content, message.error);
                    delete this.callBackList[message.responseId];
                }
            }
            else if (name in this.eventMap) {
                this.eventMap[name].forEach(function (item) {
                    item(message.content, function (content, error) {
                        _this.responseToMessage(message.requestId, content, error);
                    });
                });
            }
            else if (this.noneNameEventHandler) {
                this.noneNameEventHandler(message.content, function (content, error) {
                    _this.responseToMessage(message.requestId, content, error);
                });
            }
        };
        STMessageManager.prototype.addEventListener = function (handler, name) {
            if (name) {
                if (name in this.eventMap) {
                    this.eventMap[name].push(handler);
                }
                else {
                    this.eventMap[name] = [handler];
                }
            }
            else {
                this.noneNameEventHandler = handler;
            }
        };
        STMessageManager.prototype.removeEventListener = function (name) {
            if (name in this.eventMap) {
                delete this.eventMap[name];
            }
        };
        STMessageManager.prototype.responseToMessage = function (messageId, content, error) {
            var responseMessage = new STMessage();
            responseMessage.responseId = messageId;
            responseMessage.content = content;
            responseMessage.error = error;
            this.sendMessage(responseMessage);
        };
        STMessageManager.prototype.sendMessage = function (message) {
            var data = encodeURIComponent(JSON.stringify(message.json()));
            var iframe = document.createElement('iframe');
            iframe.height = "1";
            iframe.width = "1";
            iframe.src = __host__defined__ + "?msg=" + data;
            document.body.appendChild(iframe);
            document.body.removeChild(iframe);
            iframe = null;
        };
        return STMessageManager;
    }());
    var messageManager = new STMessageManager();
    function sendMessage() {
        var name = arguments[0];
        if (typeof name != "string") {
            throw "`name` should be string";
        }
        var content = undefined;
        var complete = undefined;
        if (typeof arguments[1] == 'function') {
            complete = arguments[1];
        }
        else {
            content = arguments[1];
        }
        if (typeof arguments[2] == 'function') {
            complete = arguments[2];
        }
        messageManager.formWebToClient(name, content, complete);
    }
    STJSBridge.sendMessage = sendMessage;
    /**
     * 监听来自客户端的消息
     *
     * @param {string} name 监听的消息名
     * @param {MessageCallBack} handler 处理消息
     */
    function addEventListener(name, handler) {
        messageManager.addEventListener(handler, name);
    }
    STJSBridge.addEventListener = addEventListener;
    /**
     * 移除对客户端的消息监听
     * @param {string} name 监听的消息名
     */
    function removeEventListener(name) {
        messageManager.removeEventListener(name);
    }
    STJSBridge.removeEventListener = removeEventListener;
    window['__inject__native_message__send__'] = function (data) {
        messageManager.formClientToWeb(data);
    };
})(STJSBridge || (STJSBridge = {}));
/* eslint-disable */
